/*------------------------------------------------------------------------------*
 * File Name: Workbook.h														*
 * Creation: Jan 5, 2008 CPY													*
 * Purpose: Worksheets and Book Management Class								*
 * Copyright (c) OriginLab Corp. 2008											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 01/07/08 v8.0799b FIX_INVALID_REFSHEET_FAIL_ACTIVE_INSERTED_LAYER		*
 *------------------------------------------------------------------------------*/
#ifndef _WORKBOOK_H
#define _WORKBOOK_H

class Workbook : public WorksheetPage
{
public:
	Workbook(PageBase &page) : WorksheetPage(page) {}
	/**
		sort sheets by their names
	Parameters:
		wOrder = [input] Default value SORT_ASCENDING sorts in ascending order, SORT_DESCENDING sorts in descending order
		nFromSheet = [input] First sheet index to sort. default is 0
		nToSheet = [input] Last sheet index to sort, default -1 sorts to last sheet
	Return:
		true if succeed, false otherwise
	*/
	bool ReorderSheetsByName(BOOL wOrder = SORT_ASCENDING, int nFromSheet = 0, int nToSheet = -1);
	/**
		Insert a new sheet to the book before or after given index or sheet name
	Parameters:
		lpcszRefSheetName = [input] if not NULL, use a the reference sheet to insert before or after
		nRefSheetIndex = [input] if >=0 the index before/after which a new sheet has to be inserted. If <0 and lpcszRefSheetName=NULL, will insert as first sheet or last depending on bInsertBefore 
		lpcszNewSheetName = [input] Optional name of the new layer. More details can refer to Page::AddLayer
		bReportSheet = [input] false will insert a flat sheet and true will insert a report sheet
		lpcszTemplate = [input]	Optional template to load the layer from. More details can refer to Page::AddLayer
	Return:
		Valid Datasheet if success
	*/
	Datasheet InsertSheet(LPCSTR lpcszRefSheetName=NULL, int nRefSheetIndex = -1, bool bInsertBefore = true, LPCSTR lpcszNewSheetName = NULL, bool bReportSheet=false, LPCSTR lpcszTemplate = NULL);
	/**
		Add a flat sheet using default template
	*/
	Datasheet AddSheet(LPCSTR lpcszNewSheetName = NULL) {
		return InsertSheet(NULL,-1,false,lpcszNewSheetName);
	}
};

bool Workbook::ReorderSheetsByName(BOOL wOrder, int nFromSheet, int nToSheet)
{
	if(nFromSheet < 0)
		return false;
	if(nFromSheet >= Layers.Count())
		return false;
	if(nToSheet > Layers.Count())
		return false;
	if(nToSheet >= 0 && nToSheet < nFromSheet)
		return false;
	if(nFromSheet == nToSheet)
		return true;// nothing to do
	
	vector<string> vsSheetNames;
	int nIndex = -1;
	foreach (Layer ly in Layers)
	{
		Datasheet ds(ly);
		nIndex++;
		if ( nIndex < nFromSheet )
			continue;
		if ( -1 != nToSheet && nIndex >= nToSheet )
			break;
		
		vsSheetNames.Add(ds.m_strBookSheet);		
	}
	vsSheetNames.Sort(wOrder);
	
	for (int ii = 0; ii < vsSheetNames.GetSize(); ii++)
	{
		Worksheet wks(vsSheetNames[ii]);
		wks.SetIndex(ii + nFromSheet);
	}
	return true;
}

/* Example:
void ins(string strName, bool bBefore=true, bool bReoprt = false, string strNew = "Junk")
{
	Workbook aa = Project.Pages();
	Worksheet wks = aa.InsertSheet(strName, -1, bBefore, strNew, bReoprt);
	if(wks)
		printf("Inserted %s at %d\n", wks.GetName(), wks.GetIndex());
}
*/
Datasheet Workbook::InsertSheet(LPCSTR lpcszRefSheetName, int nRefSheetIndex, bool bInsertBefore, LPCSTR lpcszNewSheetName, 
bool bReportSheet, LPCSTR lpcszTemplate)
{
	int nNewIndex = 0;
	Worksheet wksTemp;
	string strRefSheet = lpcszRefSheetName;	
	bool bHasRefSheet = true; /// Hong 01/07/08 v8.0799b FIX_INVALID_REFSHEET_FAIL_ACTIVE_INSERTED_LAYER
	if(!strRefSheet.IsEmpty() && (wksTemp = Layers(strRefSheet)))
		nNewIndex = wksTemp.GetIndex();	
	else if ( nRefSheetIndex >= 0 && nRefSheetIndex < Layers.Count() )
		nNewIndex = nRefSheetIndex;
	/// Hong 01/07/08 v8.0799b FIX_INVALID_REFSHEET_FAIL_ACTIVE_INSERTED_LAYER
	else
	{
		bHasRefSheet = false;
	}
	/// end FIX_INVALID_REFSHEET_FAIL_ACTIVE_INSERTED_LAYER
	
	//if(!bInsertBefore)
	if(!bInsertBefore && bHasRefSheet) /// Hong 01/07/08 v8.0799b FIX_INVALID_REFSHEET_FAIL_ACTIVE_INSERTED_LAYER
		nNewIndex++;
	DWORD dwCntrl = CREATE_UNDOABLE;
	DWORD dwOptions = 0;
	if(bReportSheet)
	{
		lpcszTemplate = NULL;
		dwCntrl |= WP_SHEET_HIERARCHY | CREATE_NO_DEFAULT_TEMPLATE | WP_SHEET_THIN_COL_HEADERS | WP_SHEET_MAIN_NAN_AS_BLANK;
		dwOptions |= GETNBRANCH_HIDE_COL_LABELS | GETNBRANCH_FIT_COL_WIDTH | GETNBRANCH_FIT_ROW_HEIGHT;
	}
	UndoBlock ub;
	int nIndex = AddLayer(lpcszNewSheetName, dwCntrl, lpcszTemplate, dwOptions);
	Datasheet wks = Layers(nIndex);	
	//if(!bInsertBefore && strRefSheet.IsEmpty() && nRefSheetIndex < 0)
	if(!bInsertBefore && !bHasRefSheet) /// Hong 01/07/08 v8.0799b FIX_INVALID_REFSHEET_FAIL_ACTIVE_INSERTED_LAYER
	{
		page_set_active_layer(*this, nIndex, false);
		return wks;
	}
	wks.SetIndex(nNewIndex);
	// SetIndex will NOT active worksheet if index not changed
	//page_set_active_layer(*this, nNewIndex, false); CPY: it seems SetIndex activated it already
	return wks;
}


#endif //_WORKBOOK_H

